/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWSession;

public final class VWAttachmentTrackingQuery {
    protected VWSession mySession;
    protected VWAttachment myAttachment;
    protected int myBufferSize = 0;
    protected boolean needsInit = true;
    protected boolean noMoreInDatabase = false;
    protected VWRosterElement[] re = null;
    protected int currentElement = 0;
    protected VWRosterElement fromHere = null;
    protected VWRosterElement sneakyPeek = null;

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 14:10:30  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dsiegfried  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.4  $";
    }

    protected VWAttachmentTrackingQuery(VWSession aSession, VWAttachment anAttachment) {
        this.mySession = aSession;
        this.myAttachment = anAttachment;
        this.myBufferSize = 20;
        this.needsInit = true;
        this.noMoreInDatabase = false;
        this.sneakyPeek = null;
    }

    public VWRosterElement next() throws VWException {
        if (this.sneakyPeek != null) {
            this.fromHere = this.sneakyPeek;
            this.sneakyPeek = null;
            return this.fromHere;
        }
        if (this.needsInit) {
            this.re = this.mySession.fetchAttachmentIsReferencedBy(this.myAttachment, this.myBufferSize, this.fromHere);
            this.noMoreInDatabase = this.re == null || this.myBufferSize != this.re.length;
            this.currentElement = 0;
            this.sneakyPeek = null;
            this.needsInit = false;
        }
        if (this.re == null || this.re.length == 0) {
            return null;
        }
        if (this.re.length <= this.currentElement && !this.noMoreInDatabase) {
            this.re = this.mySession.fetchAttachmentIsReferencedBy(this.myAttachment, this.myBufferSize, this.fromHere);
            this.noMoreInDatabase = this.re == null || this.myBufferSize != this.re.length;
            this.currentElement = 0;
        }
        if (this.re != null && this.re.length > this.currentElement) {
            this.fromHere = this.re[this.currentElement];
            this.re[this.currentElement] = null;
            ++this.currentElement;
            return this.fromHere;
        }
        return null;
    }

    public String toString() {
        return "Attachment Tracking Query: " + this.myAttachment.toString();
    }

    public boolean hasNext() throws VWException {
        boolean haveMore = false;
        if (this.sneakyPeek != null) {
            haveMore = true;
        } else if (this.re != null && this.re.length > this.currentElement) {
            haveMore = true;
        } else {
            this.sneakyPeek = this.next();
            haveMore = this.sneakyPeek != null;
        }
        return haveMore;
    }

    public void resetFetch() {
        this.needsInit = true;
        this.noMoreInDatabase = false;
        this.re = null;
        this.fromHere = null;
        this.currentElement = 0;
        this.sneakyPeek = null;
    }

    public void setAttachment(VWAttachment thisAttachment) {
        this.myAttachment = thisAttachment;
        this.resetFetch();
    }

    public VWAttachment getAttachment() {
        return this.myAttachment;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 1) {
            bufferSize = 1;
        }
        if (bufferSize > 200) {
            bufferSize = 200;
        }
        this.myBufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.myBufferSize;
    }
}

